package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;

import com.yiboshi.science.dao.ComProjectFundPlanDAO;
import com.yiboshi.science.entity.ComProjectFundPlan;

import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.param.dto.ComProjectFundPlanDTO;
import com.yiboshi.science.param.query.ComProjectFundPlanQueryVO;
import com.yiboshi.science.service.ComProjectFundPlanService;
import com.yiboshi.science.service.SystemParameterService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service
@AllArgsConstructor
public class ComProjectFundPlanServiceImpl extends BaseServiceImpl<ComProjectFundPlanDAO, ComProjectFundPlanQueryVO, ComProjectFundPlanDTO, ComProjectFundPlan> implements ComProjectFundPlanService {

    @Autowired
    private SystemParameterService systemParameterService;

    @Autowired
    private ComProjectFundPlanDAO comProjectFundPlanDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectFundPlanQueryVO vo, QueryWrapper<ComProjectFundPlanQueryVO> criteria) {

    }

    public List<ComProjectFundPlanDTO> getList() {
        List<ComProjectFundPlanDTO> fundPlanList = new ArrayList<>();
        List<SystemParameter> list = systemParameterService.getListByType(64);
        list.forEach((e) -> {
            ComProjectFundPlanDTO newVO = new ComProjectFundPlanDTO();
            newVO.setFundId(e.getId());
            newVO.setYearValue1(new BigDecimal(0.00));
            newVO.setYearValue2(new BigDecimal(0.00));
            newVO.setYearValue3(new BigDecimal(0.00));
            newVO.setYearValue4(new BigDecimal(0.00));
            newVO.setYearValue5(new BigDecimal(0.00));
            newVO.setTotalAmount(new BigDecimal(0.00));
            newVO.setFundName(e.getName());
            fundPlanList.add(newVO);
        });

        return fundPlanList;
    }

    public List<ComProjectFundPlanDTO> getListByObjectId(String objectId)
    {
        return comProjectFundPlanDAO.getListByObjectId(objectId);
    }

    public void deleteByObjectId(String objectId){
        ComProjectFundPlan model = new ComProjectFundPlan();
        model.setObjectId(objectId);
        this.delete(model);
    }

    public void insertList(List<ComProjectFundPlanDTO> list, String objectId) {
        ComProjectFundPlan model =new ComProjectFundPlan();
        model.setObjectId(objectId);
        this.delete(model);
        if (null != list) {
            List<ComProjectFundPlan> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComProjectFundPlan item = convert2Entity(list.get(i));
                item.setObjectId(objectId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }
}
