package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectConclusionMaterialDAO;
import com.yiboshi.science.entity.*;
import com.yiboshi.science.param.dto.ComProjectAuditNoteDTO;
import com.yiboshi.science.param.dto.ComProjectConclusionAuditDTO;
import com.yiboshi.science.param.dto.ComProjectConclusionDTO;
import com.yiboshi.science.param.dto.ComProjectConclusionMaterialDTO;
import com.yiboshi.science.param.query.ComProjectConclusionMaterialQueryVO;
import com.yiboshi.science.service.*;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class ComProjectConclusionMaterialServiceImpl extends BaseServiceImpl<ComProjectConclusionMaterialDAO, ComProjectConclusionMaterialQueryVO, ComProjectConclusionMaterialDTO, ComProjectConclusionMaterial> implements ComProjectConclusionMaterialService {

    @Autowired
    private ComProjectConclusionMaterialDAO comProjectConclusionMaterialDAO;

    @Autowired
    private SystemParameterService systemParameterService;

    @Autowired
    private ComProjectConclusionService comProjectConclusionService;

    @Autowired
    private ComProjectService comProjectService;

    @Autowired
    private ComProjectAuditNoteService comProjectAuditNoteService;

    @Override
    protected void setCriteriaForQuery(ComProjectConclusionMaterialQueryVO vo, QueryWrapper<ComProjectConclusionMaterialQueryVO> criteria) {

    }

    public ComProjectConclusionAuditDTO getConclusionMaterialList(String ProjectID) {

        ComProjectAudit audit = new ComProjectAudit();
        audit.setAuditType(4);

        List<ComProjectConclusionMaterialDTO> ConclusionMaterialList;
        List<ComProjectConclusionMaterialDTO> dtoList = comProjectConclusionMaterialDAO.getConclusionMaterialList(ProjectID);
        if (null != dtoList && dtoList.size() > 0) {
            ConclusionMaterialList = dtoList.stream().sorted(Comparator.comparingInt(ComProjectConclusionMaterialDTO::getShowIndex)).collect(Collectors.toList());
        }
        else {
            List<SystemParameter> ParameterList = systemParameterService.getListByType(63);
            List<SystemParameter> OrderList = ParameterList.stream().sorted((Comparator.comparingInt(SystemParameter::getDisplayOrder)))
                    .collect(Collectors.toList());

            ConclusionMaterialList = new ArrayList<>();
            OrderList.forEach(e -> {
                ComProjectConclusionMaterialDTO dto = new ComProjectConclusionMaterialDTO();
                dto.setProjId(ProjectID);
                dto.setTypeId(e.getId());
                dto.setMaterialName(e.getName());
                dto.setMaterialValue(0);
                dto.setShowIndex(e.getDisplayOrder());
                ConclusionMaterialList.add(dto);
            });
        }

        ComProject comProject = comProjectService.getById(ProjectID);
        ComProjectConclusionDTO comProjectConclusionDTO = comProjectConclusionService.getByProjId(ProjectID);

        ComProjectConclusionAuditDTO auditDTO = new ComProjectConclusionAuditDTO();
        auditDTO.setConclusionMaterialList(ConclusionMaterialList);
        auditDTO.setComProjectAudit(audit);

        auditDTO.setProjNo(comProject.getProjNo());
        auditDTO.setProjName(comProject.getProjName());
        auditDTO.setReportYear(comProject.getReportYear());
        auditDTO.setConclusionDate(comProjectConclusionDTO.getConclusionDate());
        auditDTO.setAuditPersonName(comProjectConclusionDTO.getAuditPersonName());
        auditDTO.setContractNo(comProjectConclusionDTO.getContractNo());
        auditDTO.setPaperNumber(comProjectConclusionDTO.getPaperNumber());
        auditDTO.setAppPersonName(comProjectConclusionDTO.getAppPersonName());

        //审核记录列表
        List<ComProjectAuditNoteDTO> auditList = comProjectAuditNoteService.getListByObjectId(comProjectConclusionDTO.getId());
        auditDTO.setAuditList(auditList);

        return auditDTO;
    }

    @Transactional
    public boolean SaveConclusionMaterial(ComProjectConclusionAuditDTO comProjectConclusionAuditDTO) {

        List<ComProjectConclusionMaterialDTO> dtoList = comProjectConclusionAuditDTO.getConclusionMaterialList();
        ComProjectAudit comProjectAudit = comProjectConclusionAuditDTO.getComProjectAudit();

        List<ComProjectConclusionMaterialDTO> ConclusionMaterialList = comProjectConclusionMaterialDAO.getConclusionMaterialList(dtoList.get(0).getProjId());
        if (null != ConclusionMaterialList && ConclusionMaterialList.size() > 0) {
            dtoList.forEach(e -> {
                ComProjectConclusionMaterial entity = convert2Entity(e);
                this.update(entity);
            });
        } else {
            dtoList.forEach(e -> {
                ComProjectConclusionMaterial entity = convert2Entity(e);
                this.insert(entity);
            });
        }

        ComProjectConclusion comProjectConclusion = comProjectConclusionService.getById(comProjectAudit.getAuditObjectId());
        comProjectConclusion.setConclusionDate(comProjectConclusionAuditDTO.getConclusionDate());
        comProjectConclusion.setPaperNumber(comProjectConclusionAuditDTO.getPaperNumber());
        comProjectConclusion.setContractNo(comProjectConclusionAuditDTO.getContractNo());
        comProjectConclusion.setAuditPersonName(comProjectConclusionAuditDTO.getAuditPersonName());
        comProjectConclusion.setIsStamp(comProjectConclusionAuditDTO.getIsStamp());

        comProjectConclusionService.update(comProjectConclusion);

        comProjectConclusionService.conclusionAudit(comProjectAudit);

        return true;
    }
}
