package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComExpertGroupMembersDAO;
import com.yiboshi.science.entity.ComExpertGroupMembers;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.param.dto.ComExpertGroupMembersDTO;
import com.yiboshi.science.param.query.ComExpertGroupMembersQueryVO;
import com.yiboshi.science.service.ComExpertGroupMembersService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class ComExpertGroupMembersServiceImpl extends BaseServiceImpl<ComExpertGroupMembersDAO, ComExpertGroupMembersQueryVO, ComExpertGroupMembersDTO, ComExpertGroupMembers> implements ComExpertGroupMembersService {

    @Autowired
    private ComExpertGroupMembersDAO comExpertGroupMembersDAO;

    @Override
    protected void setCriteriaForQuery(ComExpertGroupMembersQueryVO vo, QueryWrapper<ComExpertGroupMembersQueryVO> criteria) {

    }

    @Override
    public void insertMemberList(List<SelectListItem> list, String groupId) {
        ComExpertGroupMembers comExpertGroupMembers = new ComExpertGroupMembers();
        comExpertGroupMembers.setGroupId(groupId);
        this.delete(comExpertGroupMembers);
        list.forEach((f) -> {
            ComExpertGroupMembers item = new ComExpertGroupMembers();
            item.setGroupId(groupId);
            item.setExpertId(f.getKey());
            this.insert(item);
        });
    }

    @Override
    public List<SelectListItem> getExpertIdListByGroupId(String groupId) {
        return comExpertGroupMembersDAO.getExpertIdListByGroupId(groupId);
    }

    @Override
    public void deleteByGroupId(String groupId){
        ComExpertGroupMembers comExpertGroupMembers=new ComExpertGroupMembers();
        comExpertGroupMembers.setGroupId(groupId);
        this.delete(comExpertGroupMembers);
    }
}
