package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.arch.exception.BusinessException;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComExpertGroupAssignDAO;
import com.yiboshi.science.entity.AssignCount;
import com.yiboshi.science.entity.ComExpertGroupAssign;
import com.yiboshi.science.param.dto.ComExpertGroupAssignDTO;
import com.yiboshi.science.param.query.ComExpertGroupAssignQueryVO;
import com.yiboshi.science.service.ComExpertGroupAssignService;
import com.yiboshi.science.service.ComProjectService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

@Service
@AllArgsConstructor
public class ComExpertGroupAssignServiceImpl extends BaseServiceImpl<ComExpertGroupAssignDAO, ComExpertGroupAssignQueryVO, ComExpertGroupAssignDTO, ComExpertGroupAssign> implements ComExpertGroupAssignService {
    @Autowired
    private ComExpertGroupAssignDAO comExpertGroupAssignDAO;

    @Autowired
    private ComProjectService comProjectService;

    @Override
    protected void setCriteriaForQuery(ComExpertGroupAssignQueryVO vo, QueryWrapper<ComExpertGroupAssignQueryVO> criteria) {
        if (Objects.nonNull(vo.getProjId())) {
            criteria.eq("proj_id", vo.getProjId());
        }
        if (Objects.nonNull(vo.getAssignYear())) {
            criteria.eq("assign_year", vo.getAssignYear());
        }
    }

    @Override
    public Pagination<ComExpertGroupAssignDTO> getListByPage(ComExpertGroupAssignQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComExpertGroupAssignQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComExpertGroupAssignDTO> dtoList = comExpertGroupAssignDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public String assignProject(Integer year, List<String> projects, List<String> experts) {
        AtomicInteger allCount = new AtomicInteger(0);
        projects.forEach(e -> {
            AtomicInteger assignCount = new AtomicInteger(0);
            experts.forEach(f -> {
                if (!isDistribute(e, f)) {
                    ComExpertGroupAssign assign = new ComExpertGroupAssign();
                    assign.setProjId(e);
                    assign.setGroupId(f);
                    assign.setAssignYear(year);
                    this.insert(assign);
                    assignCount.incrementAndGet();
                    allCount.incrementAndGet();
                }
            });
            if (assignCount.get() > 0)
                updateAssignState(e, "add");
        });
        if(allCount.get()==0)
            throw new BusinessException("项目分配失败或专家已分配，请检查！");
        return allCount.get() + "";
    }

    public List<AssignCount> getAssignCount(String groupId) {
        return comExpertGroupAssignDAO.getAssignCount(groupId);
    }

    private boolean isDistribute(String projectId, String groupId) {
        ComExpertGroupAssign comExpertGroupAssign = new ComExpertGroupAssign();
        comExpertGroupAssign.setProjId(projectId);
        comExpertGroupAssign.setGroupId(groupId);
        comExpertGroupAssign = this.getEntity(comExpertGroupAssign);
        if (comExpertGroupAssign != null)
            return true;
        else
            return false;
    }

    private void updateAssignState(String projectId, String type) {
        Integer assignState = 1;
        Integer completed = 0;
        BigDecimal totalScore = new BigDecimal(0);
        BigDecimal averageScore = new BigDecimal(0);
//        if (type.equals("add")) {
//            completed = 0;
//            assignState = 1;
//        } else {
//
//            completed = 0;
//            assignState = 1;
//        }
        comProjectService.updateAssignState(projectId, assignState, completed, totalScore, averageScore);
    }


}
