package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.SystemUser;
import com.yiboshi.science.param.dto.ComPersonDTO;
import com.yiboshi.science.param.dto.SystemUserDTO;
import com.yiboshi.science.param.dto.UserDTO;
import com.yiboshi.science.param.query.SystemUserQueryVO;

/**
 * 用户信息表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemUserService extends BaseService<SystemUserQueryVO, SystemUserDTO, SystemUser> {

    /**
     * 根据用户名获取用户
     *
     * @param username
     * @return
     */
    SystemUserDTO findByName(String username);

    /**
     * 创建用户
     *
     * @return
     */
    SystemUser CreateUser(String username, String password, String userId, String roleId, Integer noteState);

    void updateRoleById(String userId,String id, String roleId);

    /**
     * 修改密码
     *
     * @param user
     * @return
     */
    String updatePwd(UserDTO user);

    /**
     * 功能:修改用户状态
     *
     * @param id 输入值
     */
    String updateStateById(String id, Integer noteState);

    /**
     * 验证证用户名是否存在
     *
     * @return
     */
    Boolean isExist(String username);
    /**
     * 根据人员编码获取人员信息
     *
     * @param personCode 人员编码
     * @return
     */
    SystemUser getByCode(String  personCode);
    /**
     * 重置密码
     */
    String resetPwd(ComPersonDTO dto);
    /**
     * 验证用户名
     */
    Boolean checkUserNameById(String username, String id);
    /**
     * 根据Id 获取用户
     */
    SystemUserDTO getSystemUserById(String id);
    /**
     * 根据Id 获取用户
     */
    SystemUser getByPersonId(String personId);
    /**
     * 更改用户
     */
    String updateSystemUser(SystemUserDTO dto);
}
