package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.param.dto.SpecDTO;
import com.yiboshi.science.param.dto.SystemParameterDTO;
import com.yiboshi.science.param.query.SystemParameterQueryVO;

import java.util.List;
import java.util.Map;

/**
 * 参数表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemParameterService extends BaseService<SystemParameterQueryVO, SystemParameterDTO, SystemParameter>{
    /** 根据id获取参数
     *
     * @param Id
     * @return
     */
    String getParaName(String Id);
    /** 根据id获取参数
     *
     * @param Id
     * @return
     */
    SystemParameter getParameterById(String Id);
    /** 根据typeId获取参数列表
     *
     * @param type
     * @return
     */
    List<SystemParameter> getListByType(Integer type);
    /**
     * 获取父级参数列表
     *
     * @param typeId
     * @return
     */
    List<SystemParameter> getParentListByType(Integer typeId);
    /**
     * 根据参数获取参数列表
     *
     * @param s
     * @return
     */
    Map<String, Object> getParameterList(SystemParameter s);
    /**
     * 根据参数获取参数列表
     *
     * @param typeId
     * @return
     */
    List<SelectListItem> getArrayListByType(Integer typeId);
    /**
     * 根据参数获取参数列表
     *
     * @param typeId
     * @return
     */
    List<SelectListItem> getTreeListByType(Integer typeId);
    /**
     * 获取父级参数列表
     *
     * @param
     * @return
     */
    List<SystemParameter> getParentParameterList();
    /**
     *
     * 根据子Id获取父级信息
     * @param id
     * @return
     */
    SystemParameter getParentModelByChildId(String id);
    /**
     * 保存
     * @param dto
     * @return
     */
    String save(SystemParameterDTO dto);
    /**
     * 删除
     *
     * @param id
     */
    String deleteParameterById(String id);
    /**
     * 刷新参数缓存
     * @param
     * @return
     */
    String refreshSystemParameter();

    String judgmentTitleLevel(String titleId);

    List<SelectListItem> getMultiLevelList(Integer typeId);
    /**
     * 专业数组代码列表
     * @return
     */
    List<SpecDTO> getMultiLevelIdList(Integer typeId);
}
