package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.LogsLogin;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.dto.LogsLoginDTO;
import com.yiboshi.science.param.query.LogsLoginQueryVO;

/**
 * 登录日志表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface LogsLoginService extends BaseService<LogsLoginQueryVO, LogsLoginDTO, LogsLogin> {
    /** 插入日志
     *
     * @param
     * @return
     */
    void log(String loginName,String username, String personId, String roles, String param,String loginUnit,String unitName);
    /**获取登录人次
     *
     * @param
     * @return
     */
    DataStatisticsDTO getCount();
    /**获取单日登录人次
     *
     * @param
     * @return
     */
    DataStatisticsDTO getCountByDay();
}
