package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectManufacture;
import com.yiboshi.science.param.dto.ComProjectManufactureDTO;
import com.yiboshi.science.param.query.ComProjectManufactureQueryVO;

import java.util.List;

/**
 * 试制设备预算明细表 Service
 *
 * @author xujun
 * @version 2024-12-16
 */
public interface ComProjectManufactureService extends BaseService<ComProjectManufactureQueryVO, ComProjectManufactureDTO, ComProjectManufacture> {

    /**
     * 根据对象获取经费列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectManufactureDTO> getListByObjectId(String objectId);

    /**插入经费表
     *
     * @param budgetList
     * @param objectId
     */
    void insertEquipmentList(List<ComProjectManufactureDTO> budgetList, String objectId);

    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);

}
