package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectFundComposition;
import com.yiboshi.science.param.dto.ComProjectFundCompositionDTO;
import com.yiboshi.science.param.query.ComProjectFundCompositionQueryVO;

import java.util.List;

/**
 * 经费申请表（任务书/项目申请书） Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectFundCompositionService extends BaseService<ComProjectFundCompositionQueryVO, ComProjectFundCompositionDTO, ComProjectFundComposition> {
    /** 根据对象获取合作单位列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectFundCompositionDTO> getListByObjectId(String objectId);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
    /** 插入合作单位
     *
     * @param togetherList
     * @param objectId
     */
    void insertList(List<ComProjectFundCompositionDTO> togetherList, String objectId);
}
