package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.AssignCount;
import com.yiboshi.science.entity.ComProjectAssign;
import com.yiboshi.science.param.dto.ComProjectAssignDTO;
import com.yiboshi.science.param.dto.ComProjectGroupDTO;
import com.yiboshi.science.param.query.ComProjectAssignQueryVO;

import java.util.List;
import java.util.Map;


public interface ComProjectAssignService extends BaseService<ComProjectAssignQueryVO, ComProjectAssignDTO, ComProjectAssign>{

    /**
     * 分配项目
     *
     * @return
     */

    String assignProject(Map<String, Object> map);
    /**
     * 根据Id获取分配专家信息
     *
     * @return
     */
    ComProjectAssignDTO getAssignExpertById(String id);
    /**
     * 获取分配专家列表
     *
     * @return
     */
    List<ComProjectAssignDTO> getAssignExpertList(String projectId);
    /**
     * 删除分配专家
     *
     * @return
     */
    String deleteAssignExpert(String id);
    /**
     * 删除分配专家
     *
     * @return
     */
    boolean isAssignByExpertId(String id);
    /**
     * 专家评分
     *
     * @return
     */
    String expertEvaluation(ComProjectAssignDTO dto);
    /**
     * 获取分配专家人数
     *
     * @return
     */
    List<AssignCount> getAssignCount(String expertId);
    /**
     * 分配专家
     *
     * @return
     */
    String assignProject(Integer year, List<String> projects, List<String> experts);
    /**
     * 更新分配状态
     *
     * @return
     */
    void updateAssignState(String projectId);
    /**
     * 更新分配状态
     *
     * @return
     */
    List<ComProjectGroupDTO> getProjectGroupAssignById(String id, String expertId);
}
