package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComExpert;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.param.dto.ComExpertDTO;
import com.yiboshi.science.param.query.ComExpertQueryVO;

import java.util.List;
import java.util.Map;

public interface ComExpertService extends BaseService<ComExpertQueryVO, ComExpertDTO, ComExpert>{

    /**
     * 根据id获取人员信息
     *
     * @param id 人员id
     * @return
     */
    ComExpertDTO getExpertById(String id);
    /**
     * 添加专家
     *
     * @param dto
     * @return
     */
    String insert(ComExpertDTO dto);

    /**
     * 更新专家
     *
     * @param dto
     * @return
     */
    String update(ComExpertDTO dto);

    /**
     *
     *
     * @param dto
     * @return
     */
    String report(ComExpertDTO dto);

    /**
     * 移除单位管理员
     */
    String deleteExpert(ComExpertDTO dto);


    /**
     * 功能:修改状态
     *
     * @param d 输入值
     */
    String updateExpertState(ComExpertDTO d);

    /**
     * 专家批量导入
     *
     * @param list
     * @return
     */
    String expertImport(List<ComExpertDTO> list,String unitName);

    /**
     * 验证专家是否存在
     *
     * @return
     */
    Boolean expertIsExist(String certId, String id);

    /**
     * 获取专家列表
     *
     * @return
     */
    List<SelectListItem> getExpertListByIdList(Map<String, Object> idList);

    /**
     * 获取专家列表
     * @param vo
     * @return
     */
    Pagination<ComExpertDTO> getEcaluationStatisticListByPage(ComExpertQueryVO vo);
}
