package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComEvaluationValue;
import com.yiboshi.science.param.dto.ComEvaluationItemDTO;
import com.yiboshi.science.param.dto.ComEvaluationValueDTO;
import com.yiboshi.science.param.dto.ComProjectEquipmentDTO;
import com.yiboshi.science.param.query.ComEvaluationValueQueryVO;
import org.apache.poi.hpsf.Decimal;

import java.math.BigDecimal;
import java.util.List;

/**
 * 评审分值表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComEvaluationValueService extends BaseService<ComEvaluationValueQueryVO, ComEvaluationValueDTO, ComEvaluationValue> {
    List<ComEvaluationValueDTO> getListByAssignId(String assignId);

    /**插入列表
     *
     * @param list
     * @param assignId
     */
    BigDecimal insertListByAssignId(List<ComEvaluationValueDTO> list, String assignId);

    /** 删除对象列表
     *
     * @param assignId
     */
    void deleteListByAssignId(String assignId);
}
