package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComDownload;
import com.yiboshi.science.param.dto.ComDownloadDTO;
import com.yiboshi.science.param.query.ComDownloadQueryVO;
import org.springframework.web.multipart.MultipartFile;

/**
 * 附件表 Service
 *
 * @author lkl
 * @version 2021-08-25
 */
public interface ComDownloadService extends BaseService<ComDownloadQueryVO, ComDownloadDTO,ComDownload> {
    /**
     * 文件上传
     *
     * @param
     */
    ComDownload asyncUpload(MultipartFile file);

    /**
     * 文件上传
     * @param file
     * @return
     */
    ComDownload asyncApplyBookUpload(MultipartFile file);
    /**
     * 删除文件
     *
     * @param
     */
    String delete(String id);
    /**
     * 获取文件上传文件大小
     *
     * @param
     */
    String getDirectorySize();

    ComDownloadDTO convertEntity2DTO(ComDownload entity);

    /**
     *
     * @param vo
     * @return
     */
    Pagination<ComDownloadDTO> getAllListByPage(ComDownloadQueryVO vo);

    String getFilePath(String basePath);

    String getPhysicalPath(String filePath);

    ComDownload getDownloadByFileName(String fileName);
}
