package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComConclusionCatalog;
import com.yiboshi.science.param.dto.ComConclusionCatalogDTO;
import com.yiboshi.science.param.query.ComConclusionCatalogQueryVO;

import java.util.List;

/**
 * 验收材料目录表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComConclusionCatalogService extends BaseService<ComConclusionCatalogQueryVO, ComConclusionCatalogDTO, ComConclusionCatalog> {
    /** 根据对象获取列表
     *
     * @param objectId
     * @return
     */
    List<ComConclusionCatalogDTO> getListByObjectId(String objectId);
    /**插入列表
     *
     * @param list
     * @param objectId
     */
    void insertList(List<ComConclusionCatalogDTO> list,String objectId);
}
