package com.yiboshi.science.rest.v1;


import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.config.annotation.Anonymous;
import com.yiboshi.science.entity.ComProjectConclusionMaterial;
import com.yiboshi.science.param.dto.ComProjectConclusionAuditDTO;
import com.yiboshi.science.param.dto.ComProjectConclusionMaterialDTO;
import com.yiboshi.science.param.query.ComProjectConclusionMaterialQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComProjectConclusionMaterialService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "com-project-conclusion-material", description = "结题审核材料表")
@RestController
@RequestMapping("/v1/science-admin/com-project-conclusion-material")
public class ComProjectConclusionMaterialController extends BaseController<ComProjectConclusionMaterialService, ComProjectConclusionMaterialQueryVO, ComProjectConclusionMaterialDTO, ComProjectConclusionMaterial> {

    @Autowired
    private ComProjectConclusionMaterialService comProjectConclusionMaterialService;

    @ApiOperation(value = "通过ProjectID获取结题审核材料", httpMethod = "GET", notes = "通过ProjectID获取结题审核材料")
    @GetMapping
    @RequestMapping("/getConclusionMaterialList")
    public ResponseDataModel<ComProjectConclusionAuditDTO> getConclusionMaterialList(String ProjectID) {
        return ResponseDataModel.ok(comProjectConclusionMaterialService.getConclusionMaterialList(ProjectID));
    }

    @ApiOperation(value = "保存结题审核材料", httpMethod = "POST", notes = "保存结题审核材料")
    @PostMapping("/SaveConclusionMaterial")
    @Anonymous
    public ResponseDataModel<String> SaveConclusionMaterial(@Validated @RequestBody ComProjectConclusionAuditDTO comProjectConclusionAuditDTO) {
        comProjectConclusionMaterialService.SaveConclusionMaterial(comProjectConclusionAuditDTO);
        return ResponseDataModel.ok("审核成功！");
    }
}
