package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComExpertGroupAssign;
import com.yiboshi.science.param.dto.ComExpertGroupAssignDTO;
import com.yiboshi.science.param.query.ComExpertGroupAssignQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComExpertGroupAssignService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "com-project-assign", description = "专家组分配表")
@RestController
@RequestMapping("/v1/science-admin/com-expert-group-assign")
public class ComExpertGroupAssignController extends BaseController<ComExpertGroupAssignService, ComExpertGroupAssignQueryVO, ComExpertGroupAssignDTO, ComExpertGroupAssign> {

    @Autowired
    private ComExpertGroupAssignService comExpertGroupAssignService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<ComExpertGroupAssignDTO>> getListByPage(@Validated ComExpertGroupAssignQueryVO vo, BindingResult bindingResult) {
        Pagination<ComExpertGroupAssignDTO> page = comExpertGroupAssignService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }
}
