package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComConclusionThesis;
import com.yiboshi.science.param.dto.ComConclusionThesisDTO;
import com.yiboshi.science.param.query.ComConclusionThesisQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComConclusionThesisService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 功能：结题论文记录表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "com-conclusion-thesis ",description = "结题论文记录表")
@RestController
@RequestMapping("/v1/science-admin/com-conclusion-thesis")
public class ComConclusionThesisController extends BaseController<ComConclusionThesisService, ComConclusionThesisQueryVO, ComConclusionThesisDTO, ComConclusionThesis> {

    @Autowired
    private ComConclusionThesisService comConclusionThesisService;
    /**
     * 功能:分页查询
     *
     * @param vo 查询条件
     */
    @ApiOperation(value = "分页查询", httpMethod = "GET", notes = "根据参数获取列表")
    @GetMapping
    @RequestMapping(value = "/getListByPage")
    public ResponseDataModel<Pagination<ComConclusionThesisDTO>> getListByPage(@Validated ComConclusionThesisQueryVO vo, BindingResult bindingResult) {
        Pagination<ComConclusionThesisDTO> page = comConclusionThesisService.getListByPage(vo);
        if (null != page && null != page.getDataList() && page.getDataList().size() != 0) {
            page.getDataList().forEach((e) -> {
            });
        }
        return ResponseDataModel.ok(page);
    }
}
