package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 查询用户信息表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询用户信息表VO")
public class SystemUserQueryVO extends PaginationVO{
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 1)
    private String username;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 2)
    private String password;
    /** 登录名 */
    @ApiModelProperty(value = "登录名", position = 3)
    private String loginName;
    /** 用户Id */
    @ApiModelProperty(value = "用户Id", position = 4)
    private String personId;
    /** 人员编码 */
    @ApiModelProperty(value = "人员编码", position = 22)
    private String personCode;
    /** 用户类型 */
    @ApiModelProperty(value = "用户类型", position = 5)
    private Integer userType;
    /** 状态 */
    @ApiModelProperty(value = "状态", position = 6)
    private Integer noteState;

    /** 角色Id */
    @ApiModelProperty(value = "角色Id", position = 7)
    private Integer roleId;
    /** 单位Id */
    @ApiModelProperty(value = "单位Id", position = 19)
    @Length(max=36, message = "单位Id不能大于36")
    private String unitId;
    /** 姓名 */
    private String personName;
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 2)
    private String certId;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 5)
    private String sex;
    /** 手机号 */
    @ApiModelProperty(value = "手机号", position = 5)
    private String mobile;
}