package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 查询系统角色表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询系统角色表VO")
public class SystemRoleQueryVO extends PaginationVO{
    /** 角色Id */
    @ApiModelProperty(value = "角色Id", position = 1 )
    private Integer roleId;
    /** 名称 */
    @ApiModelProperty(value = "名称", position = 1)
    private String name;
    /** 权限 */
    @ApiModelProperty(value = "权限", position = 2 )
    private String authority;
}