package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 申报人培养经费预算表查询VO
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "申报人培养经费预算表查询VO")
public class ComTalentBudgetQueryVO extends PaginationVO {

    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "人才申请ID")
    private String talentId;

    @ApiModelProperty(value = "预算科目ID")
    private String budgetId;

    @ApiModelProperty(value = "预算科目名称")
    private String budgetName;

    @ApiModelProperty(value = "第一年预算")
    private BigDecimal yearValue1;

    @ApiModelProperty(value = "第二年预算")
    private BigDecimal yearValue2;

    @ApiModelProperty(value = "第三年预算")
    private BigDecimal yearValue3;

    @ApiModelProperty(value = "第四年预算")
    private BigDecimal yearValue4;

    @ApiModelProperty(value = "第五年预算")
    private BigDecimal yearValue5;

    @ApiModelProperty(value = "合计", position = 7)
    private BigDecimal amountFee;

    @ApiModelProperty(value = "排序")
    private Integer showIndex;

    @ApiModelProperty(value = "是否为必填项", position = 8)
    private Boolean isRequired;
} 