package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 查询任务书表VO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询任务书表VO")
public class ComProjectTaskQueryVO extends PaginationVO{
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 1 )
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 2 )
    private Integer reportYear;
    /** 合同书状态  0 未 填,-10 起 草, 10 待提交,20 审核中,30 返回修改，40 审核不通过， 50 审核通过*/
    @ApiModelProperty(value = "合同书状态  0 未 填,-10 起 草, 10 待提交,20 审核中,30 返回修改，40 审核不通过， 50 审核通过", position = 3 )
    private Integer taskState;
    /** 开始日期 */
    @ApiModelProperty(value = "开始日期", position = 7 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 结束日期 */
    @ApiModelProperty(value = "结束日期", position = 8 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /** 注册单位类型 */
    @ApiModelProperty(value = "注册单位类型", position = 1 )
    @Length(max=50, message = "注册单位类型不能大于50")
    private String unitType;
    /** 组织机构代码/统一社会信用代码 */
    @ApiModelProperty(value = "组织机构代码/统一社会信用代码", position = 1 )
    @Length(max=50, message = "组织机构代码/统一社会信用代码不能大于50")
    private String organizationCode;
    /** 通讯地址 */
    @ApiModelProperty(value = "通讯地址", position = 1)
    @Length(max=200, message = "通讯地址不能大于200")
    private String unitAddress;
    /** 注册所在地 */
    @ApiModelProperty(value = "注册所在地", position = 1 )
    @Length(max=50, message = "注册所在地不能大于50")
    private String registeredAddress;
    /** 邮编 */
    @ApiModelProperty(value = "邮编", position = 1 )
    @Length(max=10, message = "邮编不能大于10")
    private String postCode;
    /** 法定代表人 */
    @ApiModelProperty(value = "法定代表人", position = 1 )
    @Length(max=50, message = "法定代表人不能大于50")
    private String legalPerson;
    /** 职工总数 */
    @ApiModelProperty(value = "职工总数", position = 1 )
    private Integer workforce;
    /** 其中专科以上人员 */
    @ApiModelProperty(value = "其中专科以上人员", position = 1 )
    private Integer specializedPersonnel;
    /** 研究开发人员 */
    @ApiModelProperty(value = "研究开发人员", position = 1 )
    private Integer researchPersonnel;
    /** 开户银行 */
    @ApiModelProperty(value = "开户银行", position = 1 )
    @Length(max=100, message = "开户银行不能大于100")
    private String depositBank;
    /** 银行账号 */
    @ApiModelProperty(value = "银行账号", position = 1 )
    @Length(max=50, message = "银行账号不能大于50")
    private String bankAccount;
    /** 开户银行地址 */
    @ApiModelProperty(value = "开户银行地址", position = 1 )
    @Length(max=100, message = "开户银行地址不能大于100")
    private String depositBankAddress;
    /** 银行联行号 */
    @ApiModelProperty(value = "银行联行号", position = 1 )
    @Length(max=50, message = "银行联行号不能大于50")
    private String interbankNumber;
    /** 所属我省重点领域 */
    @ApiModelProperty(value = "所属我省重点领域", position = 13 )
    @Length(max=50, message = "所属我省重点领域不能大于50")
    private String keyAreas;
    /** 电话 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String telephone;
    /** 传真 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String fax;
    /** 项目分工 */
    @ApiModelProperty(value = "项目分工", position = 8 )
    @Length(max=300, message = "项目分工不能大于300")
    private String projWork;
    /** 项目联系人姓名 */
    @ApiModelProperty(value = "项目联系人姓名", position = 16)
    @Length(max=100, message = "项目联系人姓名不能大于100")
    private String linkName;
    /** 联系人手机 */
    @ApiModelProperty(value = "联系人手机", position = 16)
    @Length(max=50, message = "联系人手机不能大于50")
    private String linkMobile;
    /** 传真 */
    @ApiModelProperty(value = "传真", position = 16)
    @Length(max=100, message = "传真不能大于100")
    private String linkFax;
    /** 电子邮箱 */
    @ApiModelProperty(value = "电子邮箱", position = 16)
    @Length(max=100, message = "电子邮箱不能大于100")
    private String linkEmail;
    /** 是否科技报告 0 否 1 是 */
    @ApiModelProperty(value = "是否科技报告", position = 1 )
    private Integer isTechnologyReport;
    /** 立项报告 */
    @ApiModelProperty(value = "立项报告", position = 2 )
    private Integer projectReport;
    /** 进展报告 */
    @ApiModelProperty(value = "进展报告", position = 2 )
    private Integer progressReport;
    /** 专题报告 */
    @ApiModelProperty(value = "专题报告", position = 2 )
    private Integer specialReport;
    /** 最终报告 */
    @ApiModelProperty(value = "最终报告", position = 2 )
    private Integer finalReport;
    /** 合同书(附件Id) */
    @ApiModelProperty(value = "合同书(附件Id)", position = 1 )
    @Length(max=150, message = "合同书(附件Id)不能大于36")
    private String contract;
    /** 单位是否审核通过 0 否 1 通过 */
    @ApiModelProperty(value = "单位是否审核通过 0 否 1 通过", position = 1 )
    private Integer isUnitAuditPass;

    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private String projName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    private String projNo;
    /** 项目类型 */
    @ApiModelProperty(value = "项目类型", position = 3 )
    private Integer systemType;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date projStart;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date projEnd;
    /** 项目状态 -10 起草,10 待提交, 20 审核中,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 审核中,30 返回修改,40 未批准立项,50 批准立项", position = 7 )
    private Integer projState;

    /** 单位id */
    @ApiModelProperty(value = "单位id", position = 41)
    private String appUnitId;
    /** 单位名称 */
    @ApiModelProperty(value = "单位名称", position = 41)
    private String appUnitName;

    /** 人员Id */
    @ApiModelProperty(value = "人员Id", position = 41)
    private String appPersonId;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 41)
    private String appPersonName;
}
