package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 *  结题信息表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "结题信息表VO")
public class ComProjectConclusionQueryVO extends PaginationVO {
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 1)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 计划类别 */
    @ApiModelProperty(value = "计划类别", position = 2)
    @Length(max=36, message = "计划类别不能大于36")
    private String planCategory;
    /** 研究周期(开始) */
    @ApiModelProperty(value = "研究周期(开始)", position = 3 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 研究周期(结束) */
    @ApiModelProperty(value = "研究周期(结束)", position = 4)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /** 状态 状态 0 未填报 1 起草 10 待上报 20已上报 */
    @ApiModelProperty(value = "状态 0未填写 1起草 10填写完成 20已上报 30返回修改", position = 5 )
    private Integer state;
    /** 研究或推广内容完成情况 */
    @ApiModelProperty(value = "研究或推广内容完成情况", position = 6)
    @Length(max=36, message = "研究或推广内容完成情况不能大于36")
    private String promotionContent;
    /** 研究或推广目标实现情况 */
    @ApiModelProperty(value = "研究或推广目标实现情况", position = 7)
    @Length(max=36, message = "研究或推广目标实现情况不能大于36")
    private String promotionTarget;
    /** 研究水平的自我评价 */
    @ApiModelProperty(value = "研究水平的自我评价", position = 8)
    @Length(max=36, message = "研究水平的自我评价不能大于36")
    private String selfEvaluation;
    /** 取得成果情况 */
    @ApiModelProperty(value = "取得成果情况", position =9)
    @Length(max=36, message = "取得成果情况不能大于36")
    private String achievingResults;
    /** 结余 */
    @ApiModelProperty(value = "结余", position =9)
    private BigDecimal balance;
    /** 研究或推广内容及结果简介 */
    @ApiModelProperty(value = "研究或推广内容及结果简介", position =10)
    @Length(max=2147483647, message = "研究或推广内容及结果简介不能大于2147483647")
    private String researchContent;
    /** 下一步的工作打算 */
    @ApiModelProperty(value = "下一步的工作打算", position = 11)
    @Length(max=36, message = "下一步的工作打算不能大于2000")
    private String workPlan;
    /** 延期报告 */
    @ApiModelProperty(value = "延期报告", position = 12)
    @Length(max=36, message = "延期报告不能大于2000")
    private String extensionReport;
    /** 纸质编号 */
    @ApiModelProperty(value = "纸质编号", position = 6 )
    private String paperNumber;
    /** 项目合同编号 */
    @ApiModelProperty(value = "项目合同编号", position = 6 )
    private String contractNo;
    /** 结题审核人 */
    @ApiModelProperty(value = "结题审核人", position = 6 )
    private String auditPersonName;
    /** 结题日期 */
    @ApiModelProperty(value = "结题日期", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date conclusionDate;
    /** 是否盖章 1是 0否*/
    @ApiModelProperty(value = "是否盖章 1是 0否", position = 5 )
    private Integer isStamp;
    /** 论文上传状态 0 未上传  1待审核 10审核通过 30 返回修改  20审核不通过*/
    @ApiModelProperty(value = "论文上传状态 0 未上传  1待审核 10审核通过 30 返回修改  20审核不通过", position = 5 )
    private Integer thesisState;

    /** 申报人Id */
    @ApiModelProperty(value = "申报人Id", position = 9 )
    @Length(max=36, message = "申报人Id不能大于36")
    private String appPersonId;
    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 8 )
    @Length(max=36, message = "申报单位Id不能大于36")
    private String appUnitId;
    /** 项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项", position = 7 )
    private Integer projState;
}