package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "结题审核材料表VO")
public class ComProjectConclusionMaterialQueryVO extends PaginationVO {

    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 1)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 材料类型Id */
    @ApiModelProperty(value = "材料类型Id", position = 2)
    @Length(max=36, message = "材料类型Id不能大于36")
    private String typeId;
    /** 材料选择值 0否  1是 */
    @ApiModelProperty(value = "材料选择值 0否  1是", position = 3)
    private Integer materialValue;
    /** 序号 */
    @ApiModelProperty(value = "序号", position = 3)
    private Integer showIndex;
}
