package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 项目课颖设置表DTO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "项目课颖设置表DTO")
public class ComProjectSubDTO extends BaseDTO {
    /** 对象Id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象Id（项目Id/任务书Id）", position = 1 )
    @Length(max=36, message = "对象Id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 课题名称 */
    @ApiModelProperty(value = "课题名称", position = 2 )
    @Length(max=100, message = "课题名称不能大于100")
    private String projName;
    /** 课题承担单位 */
    @ApiModelProperty(value = "课题承担单位", position = 2 )
    @Length(max=100, message = "单位国别不能大于100")
    private String undertakingUnit;
    /** 所在地 */
    @ApiModelProperty(value = "所在地", position = 3 )
    @Length(max=100, message = "所在地不能大于100")
    private String address;
    /** 课颖负责人 */
    @ApiModelProperty(value = "课颖负责人", position = 2 )
    @Length(max=50, message = "课颖负责人不能大于50")
    private String director;
    /** 课题预算总经费 */
    @ApiModelProperty(value = "课题预算总经费", position = 4 )
    private BigDecimal totalBudget;
    /** 其中:省科技经费 */
    @ApiModelProperty(value = "其中:省科技经费", position = 4 )
    private BigDecimal govBudget;
    /** 自筹经费 */
    @ApiModelProperty(value = "自筹经费", position = 4 )
    private BigDecimal selfBudget;
    /** 合作单位 */
    @ApiModelProperty(value = "合作单位", position = 4 )
    @Length(max=100, message = "合作单位不能大于100")
    private String cooperativeUnits;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 4 )
    private String fileId;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    @Length(max=36, message = "附件Id不能大于36")
    private String downloadId;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 6)
    private String fileName;
    /** URL */
    @ApiModelProperty(value = "URL", position = 7)
    private String downloadUrl;
}