package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目申请书在研项目情况表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目申请书在研项目情况表DTO")
public class ComProjectResearchDTO extends BaseDTO {
    /** 项目id / */
    @ApiModelProperty(value = "项目id", position = 1 )
    @Length(max=36, message = "项目id不能大于36")
    private String objectId;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 3 )
    @Length(max=100, message = "项目名称不能大于100")
    private String projName;
    /** 批准单位 */
    @ApiModelProperty(value = "批准单位", position = 4 )
    @Length(max=100, message = "批准单位不能大于100")
    private String approveUnit;
    /** 负责人 */
    @ApiModelProperty(value = "负责人", position = 5 )
    @Length(max=100, message = "负责人不能大于100")
    private String leader;
    /** 起止年限（开始） */
    @ApiModelProperty(value = "起止年限", position = 6 )
    private Date startDate;
    /** 起止年限（结束） */
    @ApiModelProperty(value = "起止年限", position = 6 )
    private Date endDate;
    /** 项目经费 */
    @ApiModelProperty(value = "项目经费", position = 7 )
    private BigDecimal funds;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
}