package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.entity.ComProjectAudit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "结题审核材料审核DTO")
public class ComProjectConclusionAuditDTO extends BaseDTO {

    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    @Length(max=150, message = "项目名称不能大于50")
    private String projName;
    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 6 )
    private Integer reportYear;
    /** 纸质编号 */
    @ApiModelProperty(value = "纸质编号", position = 6 )
    private String paperNumber;
    /** 项目合同编号 */
    @ApiModelProperty(value = "项目合同编号", position = 6 )
    private String contractNo;
    /** 项目负责人 */
    @ApiModelProperty(value = "项目负责人", position = 6 )
    private String appPersonName;
    /** 结题审核人 */
    @ApiModelProperty(value = "结题审核人", position = 6 )
    private String auditPersonName;
    /** 结题日期 */
    @ApiModelProperty(value = "结题日期", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date conclusionDate;
    /** 是否盖章 1是 0否*/
    @ApiModelProperty(value = "是否盖章 1是 0否", position = 5 )
    private Integer isStamp;

    private List<ComProjectConclusionMaterialDTO> ConclusionMaterialList;

    private ComProjectAudit comProjectAudit;

    private List<ComProjectAuditNoteDTO> auditList;
}
