package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 年度设置表DTO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "批次表DTO")
public class ComBatchDTO extends BaseDTO {
    /** 年度 */
    private Integer year;
    /** 批次 */
    private Integer batch;
    /** 时间类型 1项目申报  2任务书上报 3中期考核 */
    private Integer timeType;
    /** 批次类型 1科研项目申报  2重点学科申报 */
    private Integer systemType;
    /** 申报开始时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reportStart;
    /** 申报结束时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reportEnd;
    /** 审核开始时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditStart;
    /** 审核结束时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditEnd;
    /** 专家审核开始时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date expertStart;
    /** 专家审核结束时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date expertEnd;
    /** 备注 */
    private String remark;

    /** description */
    @ApiModelProperty(value = "description", position = 15)
    private String description ;
    /** 获取或设置一个值，该值指示是否禁用 */
    @ApiModelProperty(value = "是否禁用", position = 16)
    private Boolean disabled ;
}
