package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 用户信息表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "用户信息表DTO")
public class CheckUserDTO extends BaseDTO {
    /** uuid */
    @ApiModelProperty(value = "uuid", position = 2)
    @NotNull(message = "uuid不能为空")
    @Length(max=36, message = "评审内容Id不能大于36")
    private String uuid;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 2)
    @NotNull(message = "密码不能为空")
    @Length(max=20, message = "密码长度不能大于20")
    private String newPassword;

}