package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 异常日志VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "异常日志VO")
public class LogsException extends BaseEntity {

    /** 日志级别 1紧急 2一般 */
    @ApiModelProperty(value = "日志级别 1紧急 2一般", position = 1 )
    private Integer logLevel;
    /** 标题 */
    @ApiModelProperty(value = "标题", position = 2 )
    @Length(max=200, message = "标题不能大于200")
    private String shortTitle;
    /** ip */
    @ApiModelProperty(value = "ip", position = 3 )
    @Length(max=100, message = "ip不能大于100")
    private String ipAddress;
    /** 操作人Id */
    @ApiModelProperty(value = "操作人Id", position = 4 )
    @Length(max=36, message = "操作人Id不能大于36")
    private String customerId;
    /** 操作页面 */
    @ApiModelProperty(value = "操作页面", position = 5 )
    @Length(max=200, message = "操作页面不能大于200")
    private String pageUrl;
    /** 请求地址 */
    @ApiModelProperty(value = "请求地址", position = 6 )
    @Length(max=200, message = "请求地址不能大于200")
    private String requestUrl;
    /** 日志参数 */
    @ApiModelProperty(value = "日志参数", position = 3)
    private String logParam;
    /** 日志内容 */
    @ApiModelProperty(value = "日志内容", position = 7 )
    @Length(max=65535, message = "日志内容不能大于65535")
    private String message;

}