package com.yiboshi.science.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 人才申请表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("com_talent_apply")
@ApiModel(description = "人才申请表VO")
public class ComTalentApply extends BaseEntity {
    
    /** 人员ID */
    @ApiModelProperty(value = "人员ID", position = 1)
    @Length(max=36, message = "人员ID不能大于36")
    private String personId;

    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 2)
    private Integer reportYear;

    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 2)
    @Length(max=36, message = "申报单位Id不能大于36")
    private String appUnitId;

    /** 申报人Id */
    @ApiModelProperty(value = "申报人Id", position = 2)
    @Length(max=36, message = "申报人Id不能大于36")
    private String appPersonId;

    /** 人才类别 */
    @ApiModelProperty(value = "人才类别", position = 2)
    @Length(max=36, message = "人才类别不能大于36")
    private String talentCategory;

    /** 人才类型 */
    @ApiModelProperty(value = "人才类型", position = 2)
    @Length(max=350, message = "人才类型不能大于350")
    private String talentType;

    @ApiModelProperty(value = "是否是省级或省级以上人才")
    private Integer isProvincialTalent;
    
    /** 荣誉称号 */
    @ApiModelProperty(value = "荣誉称号", position = 3)
    @Length(max=1000, message = "荣誉称号不能大于1000")
    private String honoraryTitle;
    
    /** 在国家、省级一级学术团体任职情况（包括任职时间和职务） */
    @ApiModelProperty(value = "任职情况1", position = 4)
    @Length(max=1000, message = "任职情况1不能大于1000")
    private String holdPost1;
    
    /** 担任国内统计源期刊职务情况（包括任职时间和职务） */
    @ApiModelProperty(value = "任职情况2", position = 5)
    @Length(max=1000, message = "任职情况2不能大于1000")
    private String holdPost2;
    
    /** 担任国家或省级重点学科/专科、重点实验室、内设研究机构负责人情况（包括任职时间和职务） */
    @ApiModelProperty(value = "任职情况3", position = 6)
    @Length(max=1000, message = "任职情况3不能大于1000")
    private String holdPost3;
    
    /** 支持条件 */
    @ApiModelProperty(value = "支持条件", position = 7)
    @Length(max=5000, message = "支持条件不能大于5000")
    private String supportingConditions;
    
    /** 研究类型 */
    @ApiModelProperty(value = "研究类型", position = 8)
    @Length(max=36, message = "研究类型不能大于36")
    private String researchType;
    
    /** 研究开始时间 */
    @ApiModelProperty(value = "研究开始时间", position = 9)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date researchStart;
    
    /** 研究结束时间 */
    @ApiModelProperty(value = "研究结束时间", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date researchEnd;
    
    /** 资助经费 */
    @ApiModelProperty(value = "资助经费", position = 11)
    private BigDecimal supportFund;
    
    /** 研究内容 */
    @ApiModelProperty(value = "研究内容", position = 12)
    @Length(max=1000, message = "研究内容不能大于1000")
    private String researchContent;
    
    /** 技术特点 */
    @ApiModelProperty(value = "技术特点", position = 13)
    @Length(max=65535, message = "技术特点不能大于65535")
    private String technicalSkill;
    
    /** 量化指标 */
    @ApiModelProperty(value = "量化指标", position = 14)
    @Length(max=65535, message = "量化指标不能大于65535")
    private String qualityTarget;
    
    /** 研究条件 */
    @ApiModelProperty(value = "研究条件", position = 15)
    @Length(max=65535, message = "研究条件不能大于65535")
    private String researchCondition;
    
    /** 研究进度 */
    @ApiModelProperty(value = "研究进度", position = 16)
    @Length(max=65535, message = "研究进度不能大于65535")
    private String researchProgress;
    
    /** 计划目标 */
    @ApiModelProperty(value = "计划目标", position = 17)
    @Length(max=1000, message = "计划目标不能大于1000")
    private String planTarget;
    
    /** 单位意见 */
    @ApiModelProperty(value = "单位意见", position = 18)
    @Length(max=1000, message = "单位意见不能大于1000")
    private String unitAdvice;
    
    /** 申请经费 */
    @ApiModelProperty(value = "申请经费", position = 19)
    private BigDecimal applyFund;
    
    /** 其他经费 */
    @ApiModelProperty(value = "其他经费", position = 20)
    private BigDecimal otherFund;
    
    /** 总经费 */
    @ApiModelProperty(value = "总经费", position = 21)
    private BigDecimal totalFund;

    /** 人才申报状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准,50 批准 */
    @ApiModelProperty(value = "人才申报状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准,50 批准", position = 7 )
    private Integer talentState;

    /** 项目完成状态 */
    @ApiModelProperty(value = "项目完成状态", position = 22)
    private String completeStatus;

    /** 专家/专家组是否评审完成  0否 1是 */
    @ApiModelProperty(value = "是否评审完成", position = 6 )
    private Integer completed;

    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6 )
    private Integer assignState;

    /** 总分 */
    @ApiModelProperty(value = "总分", position = 4)
    private BigDecimal totalScore;

    /** 平均分 */
    @ApiModelProperty(value = "平均分", position = 4)
    private BigDecimal averageScore;
} 