package com.yiboshi.science.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

/**
 *  信息发送记录表
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Getter
@Setter
public class ComSendingRecord extends BaseEntity {
    /** 发送类型 1注册 2人员审核 3单位审核 */
    @ApiModelProperty(value = "发送类型 1注册 2人员审核 3单位审核", position = 1 )
    private Integer sendType;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 2)
    @Length(max=36, message = "电话号码不能大于20")
    private String mobile;
    /** 发送状态 1成功  2失败 */
    @ApiModelProperty(value = "发送状态 1成功  2失败", position = 3 )
    private Integer state;
}