package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 经费申请表（任务书/项目申请书）VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "设备仪器经费表（任务书/项目申请书）")
public class ComProjectEquipment extends BaseEntity {

    /** 购置类型Id */
    @ApiModelProperty(value = "购置类型Id", position = 2 )
    @Length(max=36, message = "购置类型Id不能大于36")
    private String purchaseId;
    /** 对象id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象id（项目Id/任务书Id）", position = 2 )
    @Length(max=36, message = "对象id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 设备仪器名称 */
    @ApiModelProperty(value = "设备仪器名称", position = 1 )
    @Length(max=100, message = "设备仪器名称不能大于100")
    private String name;
    /** 功能和技术指标 */
    @ApiModelProperty(value = "功能和技术指标", position = 1 )
    @Length(max=200, message = "功能和技术指标不能大于200")
    private String functionTarget;
    /** 规格型号 */
    @ApiModelProperty(value = "规格型号", position = 1 )
    @Length(max=100, message = "规格型号不能大于100")
    private String specificationType;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 1)
    private Integer quantity;
    /** 金额 */
    @ApiModelProperty(value = "金额", position = 3)
    private BigDecimal totalBudget;
    /** 用途 */
    @ApiModelProperty(value = "用途", position = 1)
    @Length(max=200, message = "用途不能大于200")
    private String useFrom;

    /** 购置单位 */
    @ApiModelProperty(value = "购置单位", position = 1)
    @Length(max=100, message = "购置单位不能大于100")
    private String buyUnit;
    /** 存放单位(地点) */
    @ApiModelProperty(value = "存放单位(地点)", position = 1)
    @Length(max=200, message = "存放单位(地点)不能大于200")
    private String storageLocation;
    /** 设备类型 */
    @ApiModelProperty(value = "设备类型", position = 1)
    @Length(max=100, message = "设备类型不能大于100")
    private String equipmentType;
    /** 主要生产厂家及国别 */
    @ApiModelProperty(value = "主要生产厂家及国别", position = 1)
    @Length(max=100, message = "主要生产厂家及国别不能大于100")
    private String manufacturer;
    /** 单价(万元/台套) */
    @ApiModelProperty(value = "单价(万元/台套)", position = 3)
    private BigDecimal unitPrice;
    /** 拟开发共享范围 */
    @ApiModelProperty(value = "拟开发共享范围", position = 3)
    private String sharedScope;
}