package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家评审专业表")
public class ComExpertGroupMembers extends BaseEntity {
    /** 专家组Id */
    @ApiModelProperty(value = "专家组Id", position = 1)
    @Length(max=36, message = "专家组Id不能大于36")
    private String groupId;
    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;
    /** 是否组长 1是 0否 */
    @ApiModelProperty(value = "是否组长 1是 0否", position = 1)
    private Integer leader;
}
