package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.SystemUserRole;
import com.yiboshi.science.param.dto.SystemUserDTO;
import com.yiboshi.science.param.dto.SystemUserRoleDTO;
import com.yiboshi.science.param.query.SystemUserRoleQueryVO;

import java.util.List;

/**
 * 用户角色表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemUserRoleDAO extends BaseMapper<SystemUserRole>, BaseDAO<SystemUserRoleQueryVO,SystemUserRoleDTO, SystemUserRole> {
    SystemUserDTO getUserRoleByCertId(String certId, String roleId);
    List<SystemUserRoleDTO> getRoleListByPersonId(String personId, String roleId);
}
