package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.SystemMenuRole;
import com.yiboshi.science.param.dto.SystemMenuRoleDTO;
import com.yiboshi.science.param.query.SystemMenuRoleQueryVO;

import java.util.List;

/**
 * 菜单权限表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemMenuRoleDAO extends BaseMapper<SystemMenuRole>, BaseDAO<SystemMenuRoleQueryVO, SystemMenuRoleDTO, SystemMenuRole> {

    void deleteMenuRoleBatch(int roleId, String parentId);

    void deleteMenuRole(int roleId, String menuId);

    List<SystemMenuRole> getMenuListById(int roleId, String parentId, String menuId);
}
