package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComExpert;
import com.yiboshi.science.entity.SystemMenu;
import com.yiboshi.science.param.dto.ComExpertDTO;
import com.yiboshi.science.param.query.ComExpertQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface ComExpertDAO extends BaseMapper<ComExpert>, BaseDAO<ComExpertQueryVO,ComExpertDTO,ComExpert> {
    ComExpertDTO getExpertById(String id);

    ComExpertDTO getExpertByCertId(String certId);

    List<ComExpertDTO> getExpertListByIdList(@Param("ew") Wrapper<SystemMenu> queryWrapper);

    Page<ComExpertDTO> getEcaluationStatisticListByPage(Page<ComExpertQueryVO> page, @Param("ew") Wrapper<ComExpertQueryVO> queryWrapper);
}
