package com.yiboshi.science.config.security;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Collection;

@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class SecurityUser implements UserDetails, CredentialsContainer {
    private static final long serialVersionUID = 500342423423425L;
    /** 用户id 人员id */
    private String userId;
    /** 用户id 人员id */
    private String personId;
    /** 账号 */
    private String username;
    /** 密码 */
    private String password;
    /** 登录名 */
    private String loginName;
    /** 角色Id */
    private String roles;
    /** 单位Id */
    private String unitId;
    /** 单位编码 */
    private String unitCode;
    /** 单位名称 */
    private String unitName;
    /** 专家id */
    private String expertId;
    /** 状态 1->启用 0->停用 */
    private Integer state;
    private Collection<? extends GrantedAuthority> authorities;
    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return authorities;
    }
    @Override
    public String getPassword() { return password;}
    @Override
    public String getUsername() {
        return username;
    }
    @Override
    public boolean isAccountNonExpired() {
        return true;
    }
    @Override
    public boolean isAccountNonLocked() {
        return true;
    }
    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }
    @Override
    public boolean isEnabled() {
        return true;
    }
    @Override
    public void eraseCredentials() {
    }
}
