package com.yiboshi.science.api;

import com.alibaba.fastjson.JSON;
import com.yiboshi.arch.exception.BusinessException;
import com.yiboshi.science.config.security.SecurityUserHolder;
import com.yiboshi.science.service.LogsExceptionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Service("RestTemplateService")
@Slf4j
public class RestTemplateService<T> {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private LogsExceptionService logsExceptionService;

    /**
     * get请求
     *
     * @param url 请求路径
     * @return
     */
    public String getForObject(String url) {
        String message = restTemplate.getForObject(url, String.class);
        return message;
    }

    /**
     * get请求(map传参)
     *
     * @param url 请求路劲
     * @return
     */
    public String getForObject(String url, Map params) {
        String message = restTemplate.getForObject(url, String.class, params);
        return message;
    }

    /**
     * post请求
     *
     * @param url 请求路劲
     * @return
     */
    public String postForObject(String url) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Authorization", "Bearer " + SecurityUserHolder.getToken());
        ResponseEntity<String> message = restTemplate.postForEntity(url, new HttpEntity<String>(null, headers), String.class);
        return message.getBody();
    }

    /**
     * post请求(map传参)
     *
     * @param url 请求路劲
     * @return
     */
    public String postForObject(String url, Map params) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Authorization", "Bearer " + SecurityUserHolder.getToken());
        ResponseEntity<String> message = restTemplate.postForEntity(url, new HttpEntity<String>(null, headers), String.class, params);
        return message.getBody();
        //   headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        //   headers.add("Authorization", "Bearer " + JwtTokenUtil.getToken());
    }

    public String exchange(String url, HttpMethod method, String entityJson, Map<String, String> headersMap) {
        ResponseEntity<String> result;
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        if (null != headersMap) {
            for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                headers.add(entry.getKey(), entry.getValue());
            }
        }
        try {
            result = restTemplate.exchange(url, method, new HttpEntity<>(entityJson, headers), String.class);
            return result.getBody();
        } catch (Exception e) {
            logsExceptionService.logs(null, new RuntimeException("调用接口失败,url:" + url + ",参数:" + entityJson), "调用接口失败");
            return null;
        }
    }
}

