package com.yiboshi.science.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static Date getTime(){
        return Calendar.getInstance().getTime();
    }
    public static int getYear(){
        return Calendar.getInstance().get(Calendar.YEAR);
    }

    public static String FormatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    /**
     * 格式化起止年限
     * @param date 开始日期
     * @return 格式化后的日期范围字符串
     */
    public static String formatDateRange(Date date, int type) {
        // 定义日期格式
        SimpleDateFormat sdf;
        if (type == 1)
            sdf = new SimpleDateFormat("yyyy年MM月");
        else
            sdf = new SimpleDateFormat("yyyy年MM月dd日");

        return sdf.format(date);
    }

    public static int getDateYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date); // 将Date对象设置到Calendar对象中
        return calendar.get(Calendar.YEAR);
    }
}
