package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.LogsOperationDAO;
import com.yiboshi.science.entity.LogsOperation;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.LogsOperationDTO;
import com.yiboshi.science.param.query.LogsOperationQueryVO;
import com.yiboshi.science.service.LogsOperationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 操作日志表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class LogsOperationServiceImpl extends BaseServiceImpl<LogsOperationDAO, LogsOperationQueryVO, LogsOperationDTO, LogsOperation> implements LogsOperationService {

    @Autowired
    private LogsOperationDAO logsOperationDAO;

    @Override
    protected void setCriteriaForQuery(LogsOperationQueryVO vo, QueryWrapper<LogsOperationQueryVO> criteria) {
        if(Objects.nonNull(vo.getCustomerId())){
            criteria.eq("customer_id", vo.getCustomerId());
        }
        if(Objects.nonNull(vo.getLogKey())){
            criteria.eq("log_key", vo.getLogKey());
        }
        if(Objects.nonNull(vo.getLogParam())){
            criteria.eq("log_param", vo.getLogParam());
        }
        if(Objects.nonNull(vo.getRequestUrl())){
            criteria.eq("request_url", vo.getRequestUrl());
        }
        if(Objects.nonNull(vo.getBrowser())){
            criteria.eq("browser", vo.getBrowser());
        }
        if(Objects.nonNull(vo.getIpAddress())){
            criteria.eq("ip_address", vo.getIpAddress());
        }
    }

    @Override
    public Pagination<LogsOperationDTO> getListByPage(LogsOperationQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        //long total = this.count(criteria);
        Page<LogsOperationQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<LogsOperationDTO> dtoList = logsOperationDAO.getListByPage(page, criteria).getRecords();
        for (LogsOperationDTO p : dtoList) {
            for (CommonEnum.logType type : CommonEnum.logType.values()) {
                if (type.getKey().equals(p.getLogKey())) {
                    p.setLogKeyName(type.getDescription());
                    break;
                }
            }
        }
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }
}
