package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComTalentGroupDetailDAO;
import com.yiboshi.science.entity.ComTalentGroupDetail;
import com.yiboshi.science.param.dto.ComProjectGroupDetailDTO;
import com.yiboshi.science.param.dto.ComTalentGroupDetailDTO;
import com.yiboshi.science.param.query.ComProjectGroupDetailQueryVO;
import com.yiboshi.science.param.query.ComTalentApplyQueryVO;
import com.yiboshi.science.param.query.ComTalentGroupDetailQueryVO;
import com.yiboshi.science.service.ComTalentGroupDetailService;
import com.yiboshi.science.service.SystemParameterService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 人才分组明细表 Service 实现类
 *
 * @author xujun
 * @version 2025-07-23
 */

@Service
@AllArgsConstructor
public class ComTalentGroupDetailServiceImpl extends BaseServiceImpl<ComTalentGroupDetailDAO, ComTalentGroupDetailQueryVO, ComTalentGroupDetailDTO, ComTalentGroupDetail> implements ComTalentGroupDetailService {

    @Autowired
    private ComTalentGroupDetailDAO comTalentGroupDetailDAO;

    @Autowired
    private SystemParameterService systemParameterService;

    @Override
    protected void setCriteriaForQuery(ComTalentGroupDetailQueryVO vo, QueryWrapper<ComTalentGroupDetailQueryVO> criteria) {
        if (Objects.nonNull(vo.getGroupId())) {
            criteria.eq("a.group_id", vo.getGroupId());
        }
        if (Objects.nonNull(vo.getPersonName())) {
            criteria.like("b.person_name", vo.getPersonName());
        }
        if (Objects.nonNull(vo.getCertId())) {
            criteria.like("b.cert_id", vo.getCertId());
        }
        if (Objects.nonNull(vo.getKnowledgeId())) {
            criteria.eq("d.knowledge_id", vo.getKnowledgeId());
        }
        if (Objects.nonNull(vo.getKnowledgeParentId())) {
            criteria.eq("e.id", vo.getKnowledgeParentId());
        }
    }

    public ComTalentGroupDetailDTO getTalentGroupDetailByGP(String groupId, String talentId) {
        return comTalentGroupDetailDAO.getTalentGroupDetailByGP(groupId, talentId);
    }

    public List<ComTalentGroupDetailDTO> getTalentDetailList(String groupId) {
        return comTalentGroupDetailDAO.getTalentDetailList(groupId);
    }

    public List<ComTalentGroupDetailDTO> getTalentDetailList2(String groupId) {
        return comTalentGroupDetailDAO.getTalentDetailList2(groupId);
    }

    public Pagination<ComTalentGroupDetailDTO> getTalentDetailListbyPage(ComTalentGroupDetailQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComTalentGroupDetailQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComTalentGroupDetailDTO> dtoList = comTalentGroupDetailDAO.getTalentDetailListbyPage(page, criteria).getRecords();
        dtoList.forEach(e -> {
            if (Objects.nonNull(e.getSpec()))
                e.setSpecName(systemParameterService.getParameterById(e.getSpec()).getName());
            if (Objects.nonNull(e.getTalentCategory()))
                e.setTalentCategoryName(systemParameterService.getParameterById(e.getTalentCategory()).getName());
        });
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public List<ComTalentGroupDetailDTO> getTalentListByGroupIds(List<String> groupIds) {
        if (groupIds != null && groupIds.size() > 0)
            return comTalentGroupDetailDAO.getTalentListByGroupIds(groupIds);
        else
            return new ArrayList<>();
    }

    public List<ComTalentGroupDetailDTO> getMembersListByGroupIds(List<String> groupIds) {
        if (groupIds != null && groupIds.size() > 0)
            return comTalentGroupDetailDAO.getMembersListByGroupIds(groupIds);
        else
            return new ArrayList<>();
    }
}
