package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComSendingRecordDAO;
import com.yiboshi.science.entity.ComSendingRecord;
import com.yiboshi.science.param.dto.ComSendingRecordDTO;
import com.yiboshi.science.param.query.ComSendingRecordQueryVO;
import com.yiboshi.science.service.ComSendingRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 信息发送记录表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComSendingRecordServiceImpl extends BaseServiceImpl<ComSendingRecordDAO, ComSendingRecordQueryVO, ComSendingRecordDTO, ComSendingRecord> implements ComSendingRecordService {

    @Autowired
    private ComSendingRecordDAO ComSendingRecordDAO;

    @Override
    protected void setCriteriaForQuery(ComSendingRecordQueryVO vo, QueryWrapper<ComSendingRecordQueryVO> criteria) {

    }

    @Override
    public Pagination<ComSendingRecordDTO> getListByPage(ComSendingRecordQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComSendingRecordQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComSendingRecordDTO> dtoList = ComSendingRecordDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public void record(String mobile,Integer state,Integer sendType){
        ComSendingRecord record=new ComSendingRecord();
        record.setMobile(mobile);
        record.setState(state);
        record.setSendType(sendType);
        this.insert(record);
    }

}
