package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectManufactureDAO;
import com.yiboshi.science.entity.ComProjectManufacture;
import com.yiboshi.science.param.dto.ComProjectManufactureDTO;
import com.yiboshi.science.param.query.ComProjectManufactureQueryVO;
import com.yiboshi.science.service.ComProjectManufactureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 试制设备预算明细表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectManufactureServiceImpl extends BaseServiceImpl<ComProjectManufactureDAO, ComProjectManufactureQueryVO, ComProjectManufactureDTO, ComProjectManufacture> implements ComProjectManufactureService {

    @Autowired
    private ComProjectManufactureDAO comProjectManufactureDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectManufactureQueryVO vo, QueryWrapper<ComProjectManufactureQueryVO> criteria) {

    }

    @Override
    public List<ComProjectManufactureDTO> getListByObjectId(String objectId) {
        return comProjectManufactureDAO.getListByObjectId(objectId);
    }

    @Override
    public void insertEquipmentList(List<ComProjectManufactureDTO> budgetList, String objectId) {
        ComProjectManufacture E = new ComProjectManufacture();
        E.setObjectId(objectId);
        this.delete(E);
        if (null != budgetList) {
            budgetList.forEach((e) -> {
                if (!isObjectNull(e)) {
                    e.setObjectId(objectId);
                    ComProjectManufacture comProjectManufacture = convert2Entity(e);
                    this.insert(comProjectManufacture);
                }
            });
//            budgetList.forEach(e -> e.setObjectId(objectId));
//            List<ComProjectEquipment> list = convertDto2EntityList(budgetList);
//            this.insertBatch(list);
        }
    }

    @Override
    public void deleteByObjectId(String objectId) {
        ComProjectManufacture E =new ComProjectManufacture();
        E.setObjectId(objectId);
        this.delete(E);
    }
}
