package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectKpitDetailDAO;
import com.yiboshi.science.entity.ComProjectKpitDetail;
import com.yiboshi.science.param.dto.ComProjectKpitDTO;
import com.yiboshi.science.param.dto.ComProjectKpitDetailDTO;
import com.yiboshi.science.param.query.ComProjectKpitDetailQueryVO;
import com.yiboshi.science.service.ComProjectKpitDetailService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@AllArgsConstructor
public class ComProjectKpitDetailServiceImpl extends BaseServiceImpl<ComProjectKpitDetailDAO, ComProjectKpitDetailQueryVO, ComProjectKpitDetailDTO, ComProjectKpitDetail> implements ComProjectKpitDetailService {

    @Autowired
    private ComProjectKpitDetailDAO comProjectKpitDetailDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectKpitDetailQueryVO vo, QueryWrapper<ComProjectKpitDetailQueryVO> criteria) {

    }

    public List<ComProjectKpitDTO> getProjectKpitDetailStatistic(String projId) {
        List<ComProjectKpitDTO> threeLevelList = comProjectKpitDetailDAO.getProjectKpitDetail(projId);

        return threeLevelList;
    }

    public void insertList(List<ComProjectKpitDetailDTO> list, String objectId) {
        ComProjectKpitDetail model =new ComProjectKpitDetail();
        model.setObjectId(objectId);
        this.delete(model);
        if (null != list) {
            List<ComProjectKpitDetail> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComProjectKpitDetail item = convert2Entity(list.get(i));
                item.setObjectId(objectId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }
    public void deleteByObjectId(String objectId){
        ComProjectKpitDetail model = new ComProjectKpitDetail();
        model.setObjectId(objectId);
        this.delete(model);
    }
}
