package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComProjectGroupDetailDAO;
import com.yiboshi.science.entity.ComProjectGroupDetail;
import com.yiboshi.science.param.dto.ComProjectGroupDetailDTO;
import com.yiboshi.science.param.query.ComProjectGroupDetailQueryVO;
import com.yiboshi.science.service.ComProjectGroupDetailService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
@AllArgsConstructor
public class ComProjectGroupDetailServiceImpl extends BaseServiceImpl<ComProjectGroupDetailDAO, ComProjectGroupDetailQueryVO, ComProjectGroupDetailDTO, ComProjectGroupDetail> implements ComProjectGroupDetailService {

    @Autowired
    private ComProjectGroupDetailDAO comProjectGroupDetailDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectGroupDetailQueryVO vo, QueryWrapper<ComProjectGroupDetailQueryVO> criteria) {
        if (Objects.nonNull(vo.getGroupId())) {
            criteria.eq("a.group_id", vo.getGroupId());
        }
        if (Objects.nonNull(vo.getProjName())) {
            criteria.like("b.proj_name", vo.getProjName());
        }
        if (Objects.nonNull(vo.getProjNo())) {
            criteria.like("b.proj_no", vo.getProjNo());
        }
        if (Objects.nonNull(vo.getKnowledgeId())) {
            criteria.eq("d.knowledge_id", vo.getKnowledgeId());
        }
        if (Objects.nonNull(vo.getKnowledgeParentId())) {
            criteria.eq("e.id", vo.getKnowledgeParentId());
        }
    }

    public ComProjectGroupDetailDTO getProjectGroupDetailByGP(String groupId, String projId) {
        return comProjectGroupDetailDAO.getProjectGroupDetailByGP(groupId, projId);
    }

    public List<ComProjectGroupDetailDTO> getProjectDetailList(String groupId) {
        return comProjectGroupDetailDAO.getProjectDetailList(groupId);
    }

    public List<ComProjectGroupDetailDTO> getProjectDetailList2(String groupId) {
        return comProjectGroupDetailDAO.getProjectDetailList2(groupId);
    }

    public Pagination<ComProjectGroupDetailDTO> getProjectDetailListbyPage(ComProjectGroupDetailQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComProjectGroupDetailQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComProjectGroupDetailDTO> dtoList = comProjectGroupDetailDAO.getProjectDetailListbyPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public List<ComProjectGroupDetailDTO> getProjectListByGroupIds(List<String> groupIds) {
        if (groupIds != null && groupIds.size() > 0)
            return comProjectGroupDetailDAO.getProjectListByGroupIds(groupIds);
        else
            return new ArrayList<>();
    }

    public List<ComProjectGroupDetailDTO> getMembersListByGroupIds(List<String> groupIds) {
        if (groupIds != null && groupIds.size() > 0)
            return comProjectGroupDetailDAO.getMembersListByGroupIds(groupIds);
        else
            return new ArrayList<>();
    }
}
