package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectGroupAssignDAO;
import com.yiboshi.science.entity.ComProjectGroupAssign;
import com.yiboshi.science.param.dto.ComExpertSpecDTO;
import com.yiboshi.science.param.dto.ComProjectAssignDTO;
import com.yiboshi.science.param.dto.ComProjectGroupAssignDTO;
import com.yiboshi.science.param.query.ComProjectGroupAssignQueryVO;
import com.yiboshi.science.service.ComExpertSpecService;
import com.yiboshi.science.service.ComProjectGroupAssignService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class ComProjectGroupAssignServiceImpl extends BaseServiceImpl<ComProjectGroupAssignDAO, ComProjectGroupAssignQueryVO, ComProjectGroupAssignDTO, ComProjectGroupAssign> implements ComProjectGroupAssignService {
    @Autowired
    private ComProjectGroupAssignDAO comProjectGroupAssignDAO;

    @Autowired
    private ComExpertSpecService comExpertSpecService;

    @Override
    protected void setCriteriaForQuery(ComProjectGroupAssignQueryVO vo, QueryWrapper<ComProjectGroupAssignQueryVO> criteria) {

    }

    public List<ComProjectGroupAssignDTO> getAssignExpertList(String groupId) {
        List<ComProjectGroupAssignDTO> groupAssignList = comProjectGroupAssignDAO.getAssignExpertList(groupId);
        groupAssignList.forEach(e -> {
            e.setExpertType(comExpertSpecService.getExpertTypeByExpertId(e.getExpertId()));
            e.setSpecList(comExpertSpecService.getListByExpertId(e.getExpertId()));
        });
        return groupAssignList;
    }

    public ComProjectGroupAssignDTO getAssignGroupExpertById(String Id) {
        ComProjectGroupAssignDTO dto = comProjectGroupAssignDAO.getAssignGroupExpertById(Id);
        List<ComExpertSpecDTO> list = comExpertSpecService.getListByExpertId(dto.getExpertId());
        if (null != list && list.size() > 0)
            dto.setSpecList(list);

        List<ComProjectAssignDTO> assignList = comProjectGroupAssignDAO.getProjectAssignByGroupIdExpertId(dto.getGroupId(), dto.getExpertId());
        if (null != assignList && assignList.size() > 0)
            dto.setProjAssignList(assignList);

        return dto;
    }

}
