package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectFundCompositionDAO;
import com.yiboshi.science.param.dto.ComProjectFundCompositionDTO;
import com.yiboshi.science.entity.ComProjectFundComposition;
import com.yiboshi.science.param.query.ComProjectFundCompositionQueryVO;
import com.yiboshi.science.service.ComProjectFundCompositionService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@AllArgsConstructor
public class ComProjectFundCompositionServiceImpl extends BaseServiceImpl<ComProjectFundCompositionDAO, ComProjectFundCompositionQueryVO, ComProjectFundCompositionDTO, ComProjectFundComposition> implements ComProjectFundCompositionService {

    @Autowired
    private ComProjectFundCompositionDAO comProjectFundCompositionDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectFundCompositionQueryVO vo, QueryWrapper<ComProjectFundCompositionQueryVO> criteria) {

    }
    public List<ComProjectFundCompositionDTO> getListByObjectId(String objectId)
    {
        return comProjectFundCompositionDAO.getListByObjectId(objectId);
    }

    public void deleteByObjectId(String objectId){
        ComProjectFundComposition model = new ComProjectFundComposition();
        model.setObjectId(objectId);
        this.delete(model);
    }

    public void insertList(List<ComProjectFundCompositionDTO> list, String objectId) {
        ComProjectFundComposition model =new ComProjectFundComposition();
        model.setObjectId(objectId);
        this.delete(model);
        if (null != list) {
            List<ComProjectFundComposition> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComProjectFundComposition item = convert2Entity(list.get(i));
                item.setShowIndex(i+1);
                item.setObjectId(objectId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }
}
