package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectBudgetDAO;
import com.yiboshi.science.entity.ComProjectBudget;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.param.dto.ComProjectBudgetDTO;
import com.yiboshi.science.param.query.ComProjectBudgetQueryVO;
import com.yiboshi.science.service.ComProjectBudgetService;
import com.yiboshi.science.service.LogsExceptionService;
import com.yiboshi.science.service.SystemParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 经费申请表（任务书/项目申请书） Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectBudgetServiceImpl extends BaseServiceImpl<ComProjectBudgetDAO, ComProjectBudgetQueryVO, ComProjectBudgetDTO, ComProjectBudget> implements ComProjectBudgetService {

    @Autowired
    private ComProjectBudgetDAO comProjectBudgetDAO;

    @Autowired
    private SystemParameterService systemParameterService;

    @Autowired
    private LogsExceptionService logsExceptionService;


    @Override
    protected void setCriteriaForQuery(ComProjectBudgetQueryVO vo, QueryWrapper<ComProjectBudgetQueryVO> criteria) {
        if (Objects.nonNull(vo.getBudgetId())) {
            criteria.eq("budget_id", vo.getBudgetId());
        }
        if (Objects.nonNull(vo.getObjectId())) {
            criteria.eq("object_id", vo.getObjectId());
        }
        if (Objects.nonNull(vo.getTotalBudget())) {
            criteria.eq("total_budget", vo.getTotalBudget());
        }
    }

    @Override
    public List<ComProjectBudgetDTO> getList() {
        List<ComProjectBudgetDTO> budgetList = new ArrayList<>();
        List<SystemParameter> list = systemParameterService.getListByType(54);
        list.forEach((e) -> {
            ComProjectBudgetDTO newVO = new ComProjectBudgetDTO();
            newVO.setBudgetId(e.getId());
            newVO.setTotalBudget(new BigDecimal(0.00));
            newVO.setApplyFunds(new BigDecimal(0.00));
            newVO.setSelfFunds(new BigDecimal(0.00));
            newVO.setBudgetName(e.getName());
            newVO.setLevel(e.getTreeCode());
            if (Objects.nonNull(e.getSystemCode())) {
                try {
                    getParaItem(newVO, e.getSystemCode());
                } catch (Exception ex) {
                    logsExceptionService.logs(null, ex, "获取参数异常！");
                }
            }
            newVO.setCode(e.getCode());
            newVO.setType(e.getGbCode());
            budgetList.add(newVO);
        });

        return budgetList;
    }

    public List<ComProjectBudgetDTO> getListByObjectId(String objectId) {
        List<ComProjectBudgetDTO> budgetList = comProjectBudgetDAO.getListByObjectId(objectId);
        if (null == budgetList || budgetList.size() == 0)
            budgetList = this.getList();
        else {
            budgetList.forEach((e) -> {
                if (Objects.nonNull(e.getSystemCode())) {
                    try {
                        getParaItem(e, e.getSystemCode());
                    } catch (Exception ex) {
                        logsExceptionService.logs(null, ex, "经费配置异常！");
                    }
                }
            });
        }
        return budgetList;
    }

    private void getParaItem(ComProjectBudgetDTO e, String systemCode) {
        String[] arr = systemCode.split(",");
        Integer[] li = new Integer[arr.length];
        for (int i = 0; i < arr.length; i++) {
            li[i] = Integer.valueOf(arr[i]);
        }
        e.setSource(li);
    }

    @Transactional
    public void insertBudgetList(List<ComProjectBudgetDTO> budgetList, String objectId) {
        ComProjectBudget E = new ComProjectBudget();
        E.setObjectId(objectId);
        this.delete(E);
        if (null != budgetList) {
            budgetList.forEach((e) -> {
                if (!isObjectNull(e)) {
                    e.setObjectId(objectId);
                    ComProjectBudget comProjectBudget = convert2Entity(e);
                    this.insert(comProjectBudget);
                }
            });
        }
    }

    public void deleteByObjectId(String objectId) {
        ComProjectBudget E = new ComProjectBudget();
        E.setObjectId(objectId);
        this.delete(E);
    }
}
