package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.SystemMenuRole;
import com.yiboshi.science.param.dto.MenuTreeDTO;
import com.yiboshi.science.param.dto.SystemMenuRoleDTO;
import com.yiboshi.science.param.query.SystemMenuRoleQueryVO;

import java.util.List;

/**
 * 菜单权限表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemMenuRoleService extends BaseService<SystemMenuRoleQueryVO, SystemMenuRoleDTO,SystemMenuRole> {
    /** 根据角色获取菜单
     *
     * @param
     * @return
     */
    List<SystemMenuRole> getMenuRoleByRoleId(int roleId);
    /** 更新角色菜单
     *
     * @param
     * @return
     */
    String updateMenuRole(List<SystemMenuRole> menuRoleList);
    /** 插入角色菜单
     *
     * @param
     * @return
     */
    String insertMenuRoleRecord(MenuTreeDTO menuTreeDTO);
    /** 删除角色菜单
     *
     * @param
     * @return
     */
    String deleteMenuRoleRecord(MenuTreeDTO menuTreeDTO);
}
