package com.yiboshi.science.service;


import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProject;
import com.yiboshi.science.entity.ComProjectAudit;
import com.yiboshi.science.param.dto.ComProjectAuditDTO;
import com.yiboshi.science.param.dto.ComProjectDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.dto.ProjectImportDTO;
import com.yiboshi.science.param.query.ComProjectQueryVO;
import org.springframework.web.bind.annotation.PathVariable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

/**
 * 项目表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectService extends BaseService<ComProjectQueryVO, ComProjectDTO, ComProject> {
    /**
     * 更新项目状态
     *
     * @return
     */
    void updateStateOrNo(String id, Integer state, String versionNo, String projNo,Integer isFinalReturned);

    /**
     * 获取新的版本号
     *
     * @param oldVersionNo 原版本号
     * @return
     */
    String getVersionNo(String oldVersionNo);

    /**
     * 分布保存项目信息
     * @param dto
     * @return
     */
    String save(ComProjectDTO dto);

    /**
     * 修改申报单位
     *
     * @param dto
     * @return
     */
    String updateUnit(ComProjectDTO dto);

    /**
     * 根据id获取项目信息
     *
     * @param id 查询条件
     */
    ComProjectDTO getProjectById(String id);

    /**
     * 创建基础项目信息
     */
    ComProjectDTO getNewProject(Integer systemType);

    /**
     * 项目/任务书/中期考核上报
     *
     * @param e
     * @return
     */
    void report(ComProjectAudit e, String unitId, String treeCode);

    /**
     * 项目/任务书/中期考核审核
     *
     * @param e
     * @return
     */
    void audit(ComProjectAuditDTO e, String auditUnitId, String auditTreeCode);

    /**
     * 项目/任务书/中期考核审核
     *
     * @param e
     * @return
     */
    void batchAudit(ComProjectAuditDTO e, String auditUnitId, String auditTreeCode);

    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getCount(ComProject e);

    /**
     * 删除项目
     *
     * @return
     */
    String delete(String id);

    /**
     * 更新项目分配状态
     *
     * @return
     */
    void updateAssignState(String id, Integer assignState, Integer completed, BigDecimal totalScore,BigDecimal averageScore);


    DataStatisticsDTO getProjectReportCountByGov(String treeCode);

    DataStatisticsDTO getProjectReportCountByUnitId(String appUnitId);

    void export(@PathVariable String id, HttpServletRequest request, HttpServletResponse response);
    /**
     * 专家批量导入
     *
     * @param list
     * @return
     */
    List<ProjectImportDTO> projectImport(List<ProjectImportDTO> list) throws IOException;

    String updateDefenseScore (String id, BigDecimal defenseTechnologyScore, BigDecimal defenseEconomyScore);
}
